Ext.data.JsonP.sol_common_jc_ActionDefinitionUtils({"tagname":"class","name":"sol.common.jc.ActionDefinitionUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"sol.common.jc.ActionDefinitionUtils.js","href":"sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils"}],"author":[{"tagname":"author","name":"ELO Digital Office GmbH","email":null}],"version":["1.09.000"],"requires":["sol.common.IxUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"BUTTON_MODES","tagname":"property","owner":"sol.common.jc.ActionDefinitionUtils","id":"property-BUTTON_MODES","meta":{"private":true}},{"name":"TAB_CONST","tagname":"property","owner":"sol.common.jc.ActionDefinitionUtils","id":"property-TAB_CONST","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"buildRibbonFromDefinition","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-buildRibbonFromDefinition","meta":{"private":true}},{"name":"buttonEnabledHandler","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-buttonEnabledHandler","meta":{"private":true}},{"name":"buttonEnabledStatic","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-buttonEnabledStatic","meta":{"private":true}},{"name":"buttonHandler","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-buttonHandler","meta":{}},{"name":"getIconName","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-getIconName","meta":{"private":true}},{"name":"getPriority","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-getPriority","meta":{"private":true}},{"name":"getSelection","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-getSelection","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-initialize","meta":{"private":true}},{"name":"initializeRibbon","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-initializeRibbon","meta":{}},{"name":"isValidId","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-isValidId","meta":{"private":true}},{"name":"logJavaInfo","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-logJavaInfo","meta":{"private":true}},{"name":"registerBands","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-registerBands","meta":{"private":true}},{"name":"registerButtons","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-registerButtons","meta":{"private":true}},{"name":"registerButtonsNew","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-registerButtonsNew","meta":{"private":true}},{"name":"registerButtonsOld","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-registerButtonsOld","meta":{"private":true}},{"name":"registerTabs","tagname":"method","owner":"sol.common.jc.ActionDefinitionUtils","id":"method-registerTabs","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.jc.ActionDefinitionUtils","short_doc":"This class loads ELO Business Solutions action definitions and creates the ribbon, button groups and buttons. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.jc.ActionDefinitionUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils' target='_blank'>sol.common.jc.ActionDefinitionUtils.js</a></div></pre><div class='doc-contents'><p>This class loads ELO Business Solutions action definitions and creates the ribbon, button groups and buttons.</p>\n\n<p>This class is automatically called during client startup.</p>\n      <p class='version-tag'>Version: <b>1.09.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-BUTTON_MODES' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-property-BUTTON_MODES' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-property-BUTTON_MODES' class='name expandable'>BUTTON_MODES</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{BIG: {name: &quot;big&quot;, jcPrio: 1}, SMALL: {name: &quot;small&quot;, jcPrio: 3}}</code></p></div></div></div><div id='property-TAB_CONST' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-property-TAB_CONST' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-property-TAB_CONST' class='name expandable'>TAB_CONST</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{HOME: {name: &quot;home&quot;}, DOCUMENT: {name: &quot;document&quot;}, ARCHIVE: {name: &quot;archive&quot;}, VIEW: {name: &quot;view&quot;}, WORKFLOW: {name: &quot;workflow&quot;}, INTRAY: {name: &quot;intray&quot;}, SEARCH: {name: &quot;search&quot;}, NEW: {name: &quot;new&quot;}, OUTPUT: {name: &quot;output&quot;}, ORGANIZE: {name: &quot;organize&quot;}}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-buildRibbonFromDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-buildRibbonFromDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-buildRibbonFromDefinition' class='name expandable'>buildRibbonFromDefinition</a>( <span class='pre'>defs, ctx</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Builds the java client ribbon based on ribbon button / group / tab definitions given by RF_sol_common_services_Action...</div><div class='long'><p>Builds the java client ribbon based on ribbon button / group / tab definitions given by RF_sol_common_services_ActionDefinitionCollector.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>defs</span> : Object[]<div class='sub-desc'><p>action/ ribbon definition</p>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-buttonEnabledHandler' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-buttonEnabledHandler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-buttonEnabledHandler' class='name expandable'>buttonEnabledHandler</a>( <span class='pre'>access</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if the button should be enabled. ...</div><div class='long'><p>Checks, if the button should be enabled. This is used by the the new way of registering buttons and will be called dynamically.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>access</span> : Object<div class='sub-desc'><p>The access element of a button definition</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-buttonEnabledStatic' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-buttonEnabledStatic' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-buttonEnabledStatic' class='name expandable'>buttonEnabledStatic</a>( <span class='pre'>btnId, access</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, when the button should be enabled, and calls the setScriptButtonEnabled method accordingly. ...</div><div class='long'><p>Checks, when the button should be enabled, and calls the <code>setScriptButtonEnabled</code> method accordingly.\nThis is used by the old way of registering buttons and only while the button is initialized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>btnId</span> : String<div class='sub-desc'><p>A button id</p>\n</div></li><li><span class='pre'>access</span> : Object<div class='sub-desc'><p>A button access definition</p>\n</div></li></ul></div></div></div><div id='method-buttonHandler' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-buttonHandler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-buttonHandler' class='name expandable'>buttonHandler</a>( <span class='pre'>def</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>This handles the button execution. ...</div><div class='long'><p>This handles the button execution. This is used by the old and the new way of registering buttons alike.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>def</span> : Object<div class='sub-desc'><p>A button definition</p>\n</div></li></ul></div></div></div><div id='method-getIconName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-getIconName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-getIconName' class='name expandable'>getIconName</a>( <span class='pre'>buttonDef</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>buttonDef</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getPriority' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-getPriority' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-getPriority' class='name expandable'>getPriority</a>( <span class='pre'>btnDef</span> ) : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the priority from a button definition. ...</div><div class='long'><p>Retrieves the priority from a button definition.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>btnDef</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSelection' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-getSelection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-getSelection' class='name expandable'>getSelection</a>( <span class='pre'>access</span> ) : String|String[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>returns the selected element objIds. ...</div><div class='long'><p>returns the selected element objIds.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>access</span> : Object<div class='sub-desc'><p>This object determines if this returns just one or many objIds (in case of multiselect).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String|String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-initializeRibbon' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-initializeRibbon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-initializeRibbon' class='name expandable'>initializeRibbon</a>( <span class='pre'>[ctx]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Initializes ribbon buttons, groups and tabs for ELO Business Solutions. ...</div><div class='long'><p>Initializes ribbon buttons, groups and tabs for ELO Business Solutions.</p>\n\n<p>If called with a context, the method will use the old JavaClient way to initialize all the ribbon buttons.\nIf called without a context, the method will use the new dynamic button registration.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ctx</span> : Object (optional)<div class='sub-desc'><p>The current script scope.</p>\n</div></li></ul></div></div></div><div id='method-isValidId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-isValidId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-isValidId' class='name expandable'>isValidId</a>( <span class='pre'>idType, id</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>idType</span> : String<div class='sub-desc'><p>Identifier type</p>\n</div></li><li><span class='pre'>id</span> : String<div class='sub-desc'><p>Identifier</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>is valid</p>\n</div></li></ul></div></div></div><div id='method-logJavaInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-logJavaInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-logJavaInfo' class='name expandable'>logJavaInfo</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Logs the Java version and the path of the JRE ...</div><div class='long'><p>Logs the Java version and the path of the JRE</p>\n</div></div></div><div id='method-registerBands' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-registerBands' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-registerBands' class='name expandable'>registerBands</a>( <span class='pre'>bandDefinitions, [ctx]</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Registers the buton groups. ...</div><div class='long'><p>Registers the buton groups.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bandDefinitions</span> : Object[]<div class='sub-desc'><p>This contains one action definitions per button group which was found</p>\n</div></li><li><span class='pre'>ctx</span> : Object (optional)<div class='sub-desc'><p>Whether this is set or not, this method will use the old or the new way to register tabs in the client (see <a href=\"#!/api/sol.common.jc.ActionDefinitionUtils-method-initializeRibbon\" rel=\"sol.common.jc.ActionDefinitionUtils-method-initializeRibbon\" class=\"docClass\">initializeRibbon</a>)</p>\n</div></li></ul></div></div></div><div id='method-registerButtons' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-registerButtons' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-registerButtons' class='name expandable'>registerButtons</a>( <span class='pre'>buttonDefinitions, [ctx]</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Registers the butons. ...</div><div class='long'><p>Registers the butons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>buttonDefinitions</span> : Object[]<div class='sub-desc'><p>This contains one action definitions per button which was found</p>\n</div></li><li><span class='pre'>ctx</span> : Object (optional)<div class='sub-desc'><p>Whether this is set or not, this method will use the old or the new way to register tabs in the client (see <a href=\"#!/api/sol.common.jc.ActionDefinitionUtils-method-initializeRibbon\" rel=\"sol.common.jc.ActionDefinitionUtils-method-initializeRibbon\" class=\"docClass\">initializeRibbon</a>)</p>\n</div></li></ul></div></div></div><div id='method-registerButtonsNew' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-registerButtonsNew' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-registerButtonsNew' class='name expandable'>registerButtonsNew</a>( <span class='pre'>buttonDefinitions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Registers the butons in the new dynamic way. ...</div><div class='long'><p>Registers the butons in the new dynamic way.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>buttonDefinitions</span> : Object[]<div class='sub-desc'><p>This contains one action definitions per button group which was found</p>\n</div></li></ul></div></div></div><div id='method-registerButtonsOld' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-registerButtonsOld' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-registerButtonsOld' class='name expandable'>registerButtonsOld</a>( <span class='pre'>buttonDefinitions, ctx</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Registers the butons in the old fashion. ...</div><div class='long'><p>Registers the butons in the old fashion.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>buttonDefinitions</span> : Object[]<div class='sub-desc'><p>This contains one action definitions per button group which was found</p>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-registerTabs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.ActionDefinitionUtils'>sol.common.jc.ActionDefinitionUtils</span><br/><a href='source/sol.common.jc.ActionDefinitionUtils.html#sol-common-jc-ActionDefinitionUtils-method-registerTabs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.ActionDefinitionUtils-method-registerTabs' class='name expandable'>registerTabs</a>( <span class='pre'>tabDefinitions, [ctx]</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Registers the tabs. ...</div><div class='long'><p>Registers the tabs.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tabDefinitions</span> : Object[]<div class='sub-desc'><p>This contains one action definitions per tab which was found</p>\n</div></li><li><span class='pre'>ctx</span> : Object (optional)<div class='sub-desc'><p>Whether this is set or not, this method will use the old or the new way to register tabs in the client (see <a href=\"#!/api/sol.common.jc.ActionDefinitionUtils-method-initializeRibbon\" rel=\"sol.common.jc.ActionDefinitionUtils-method-initializeRibbon\" class=\"docClass\">initializeRibbon</a>)</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"singleton":true}});